package gov.va.vinci.dart.dms.biz;

import gov.va.vinci.dart.biz.DartRequest;
import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.biz.ResearchStudy;
import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestAttribute extends BusinessIntegrationTest {
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		ResearchStudy.findById(1);

		List<DartRequest> reqList = DartRequest.listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);

		DartRequest req = reqList.get(0);
		Assert.assertNotNull(req);
		Assert.assertTrue(req.getId() > 0);
	
		List<DocumentTemplate> dtList = DocumentTemplate.listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 0);

		DocumentTemplate dt = dtList.get(0);
		Assert.assertNotNull(dt);

		Document doc = Document.create(req, dt, "DNS");
		Assert.assertNotNull(doc);
		Assert.assertTrue(doc.getId() > 0);

		Attribute attr = Attribute.create(doc, "KEY", "VALUE");
		Assert.assertNotNull(attr);
		Assert.assertTrue(attr.getId() > 0);
		
		Attribute attr2 = Attribute.findById(attr.getId());
		Assert.assertNotNull(attr2);
		Assert.assertEquals(attr2, attr);
		
		attr.delete();
		
		attr2 = Attribute.findById(attr.getId());
		Assert.assertNull(attr2);

	}
}
